/* <nagm01.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library m01 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2165 (Feb 1998).
 * Mark 6 revised. IER-3053 (July 2000).
 */
#ifndef NAGM01
#define NAGM01

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
//#include <nag_stddef.h>   //Cheney 2006-6-5
#include "nag_stddef.h"
#define SIZE_T_MAX 2147483647   /* maximum size_t value */
#define SIZE_T_BITS 32            /* no. of bits in size_t */
#define PTRDIFF_T_MAX (SIZE_T_MAX/2) /* maximum ptrdiff_t value */
#define MAX_LENGTH (PTRDIFF_T_MAX/sizeof(size_t)) /* maximum size of an array */
#define ELEMENT_SPACE 256         /* max. inline scratch element */
#define NAG_MCHAP_ERROR_BUF_LEN 20
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL m01cac(double vec[], size_t n, Nag_SortOrder order, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL m01caf_f(double rv[], Integer m1, Integer m2, const char *order,
                       Integer *ifail, Integer order_len);
  extern void m01cbf_f(Integer iv[], Integer m1, Integer m2, const char *order,
                       Integer *ifail, Integer order_len);
  //Cheney change ptrdiff_t to int 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL m01csc(Pointer vec, size_t n, size_t size, ptrdiff_t stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL m01csc(Pointer vec, size_t n, size_t size, int stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);
  //Cheney change ptrdiff_t to int 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL m01ctc(Pointer vec, size_t n, size_t size, ptrdiff_t stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);*/
 extern NAG_DLL_EXPIMP void NAG_CALL m01ctc(Pointer vec, size_t n, size_t size, int stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);
  //Cheney change ptrdiff_t to int 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL m01cuc(Pointer *base, ptrdiff_t offset,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL m01cuc(Pointer *base, int offset,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL m01daf_f(const double rv[], Integer m1, Integer m2, const char *order,
                       Integer irank[], Integer *ifail, Integer order_len);
  //Cheney change ptrdiff_t to int 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL m01dsc(Pointer vec, size_t n, ptrdiff_t stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, size_t *rank, NagError *fail);*/
   extern NAG_DLL_EXPIMP void NAG_CALL m01dsc(Pointer vec, size_t n, int stride,
                                             NAG_M01_FUN compare,
                                             Nag_SortOrder order, size_t *rank, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL m01eaf_f(double rv[], Integer m1, Integer m2, Integer irank[],
                       Integer *ifail);
  //Cheney change ptrdiff_t to int 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL m01esc(Pointer vec, size_t n, size_t size, 
                                             ptrdiff_t stride, size_t *indices, NagError *fail);*/
   extern NAG_DLL_EXPIMP void NAG_CALL m01esc(Pointer vec, size_t n, size_t size, 
                                             int stride, size_t *indices, NagError *fail);
  //Cheney change ptrdiff_t to int 2006-6-5
  /*extern NAG_DLL_EXPIMP Boolean NAG_CALL m01fsc(Pointer key, Pointer vec, size_t n, ptrdiff_t stride,
                                                NAG_M01_FUN compare,
                                                Nag_SortOrder order, Nag_SearchMatch final, Pointer *match, NagError *fail);*/
  extern NAG_DLL_EXPIMP Boolean NAG_CALL m01fsc(Pointer key, Pointer vec, size_t n, int stride,
                                                NAG_M01_FUN compare,
                                                Nag_SortOrder order, Nag_SearchMatch final, Pointer *match, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL m01zac(size_t rank[], size_t n, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL m01zaf_f(Integer iperm[], Integer m1, Integer m2, Integer *ifail);
  extern void m01zbc(Integer *iperm, Integer m1, Integer m2, Integer *ifail);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGM01 */
